<?php 
require_once("../home/includes/route.php"); 
require_once("config.php"); // Include your database connection file
session_start();

// Check if the user is logged in
if (isset($_SESSION["loginId"])) {

    // Retrieve user information from the database based on loginId
    $loginId = $_SESSION["loginId"];
    $sqlUser = "SELECT sFname, sWallet, sRefWallet, sType FROM subscribers WHERE sId = ?";
    $stmtUser = $conn->prepare($sqlUser);

    if (!$stmtUser) {
        die("Error preparing SQL statement for user: " . $conn->error);
    }

    $stmtUser->bind_param("s", $loginId);
    $stmtUser->execute();
    $stmtUser->bind_result($firstName, $walletBalance, $refBalance, $userType);

    if ($stmtUser->fetch()) {
        // Determine the user's role
        $userRole = "";
        switch ($userType) {
            case 1:
                $userRole = "Subscriber";
                break;
            case 2:
                $userRole = "Agent";
                break;
            case 3:
                $userRole = "Vendor";
                break;
            default:
                $userRole = "Unknown Role";
        }

        $stmtUser->close();

        // Fetch notification message for msgId 3
        $msgId = 3;
        $sqlNotifications = "SELECT message FROM notifications WHERE msgfor = ?";
        $stmtNotifications = $conn->prepare($sqlNotifications);

        if (!$stmtNotifications) {
            die("Error preparing SQL statement for notifications: " . $conn->error);
        }

        $stmtNotifications->bind_param("i", $msgId);
        $stmtNotifications->execute();
        $stmtNotifications->bind_result($notificationMessage);

        if ($stmtNotifications->fetch()) {
            // Output JavaScript to show the SweetAlert2 modal on page load
            echo "<script>";
            echo "  window.onload = function() {";
            echo "    Swal.fire({";
            echo "      title: 'Notification',";
            echo "      text: " . json_encode($notificationMessage, JSON_HEX_APOS | JSON_HEX_QUOT) . ",";
            echo "      icon: 'info',"; // You can customize the icon
            echo "      confirmButtonText: 'OK'";
            echo "    });";
            echo "  }";
            echo "</script>";
        } else {
            echo "";
        }

        $stmtNotifications->close();
    } else {
        // Handle the case where user information couldn't be retrieved
        echo "User information not available.";
    }

} else {
    // Handle the case where the user is not logged in
    echo "User is not logged in.";
}

?>


<html lang="en" class="md device-pixel-ratio-1 device-desktop device-windows theme-light"><head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
	<meta name="apple-mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-status-bar-style" content="#f38221">
	<meta name="theme-color" content="#f38221">
	<title>KSB DATA • App</title>
	<link rel="stylesheet" href="css/framework7.bundle.min.css">
	<link rel="stylesheet" href="css/app.css">
	<link rel="stylesheet" href="css/font-awesome/css/font-awesome.min.css">
	<link rel="stylesheet" href="css/line-awesome.min.css">
	<link rel="stylesheet" href="css/flaticons/flaticon.css">
	<link rel="stylesheet" href="css/style.css">
	<!-- Add SweetAlert CSS to your HTML -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

	<link rel="apple-touch-icon" href="https://app.ksbdata.com/img/logo.png">
	<link rel="icon" href="https://app.ksbdata.com/img/logo.png">
	<link rel="preconnect" href="https://fonts.gstatic.com">
	<link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap" rel="stylesheet">
	<link rel="manifest" href="manifest.json">
	<style>
		.bg-green {
		  background-color: #84CA93; }
		  .bg-green.light {
			background-color: rgba(4, 165, 124, 0.1); }
			.bg-green.light svg path,
			.bg-green.light svg rect {
			  fill: #84CA93; }
			.bg-green.light i {
			  color: #84CA93; }	    
		.categore-box {
		  border: 1px solid var(--border-color);
		  border-radius: var(--border-radius-base);
		  background: var(--bg-white); }
		  .categore-box .icon-bx {
			height: 48px;
			width: 48px;
			border-radius: var(--border-radius-base);
			margin-bottom: 5px;
			display: flex;
			align-items: center;
			justify-content: center;
			margin-left: auto;
			margin-right: auto; }
		  .categore-box.style-1 {
			display: block;
			padding: 6px 6px 12px;
			text-align: center; }
			.categore-box.style-1 .title {
			  display: block;
			  color: var(--title);
			  font-size: 14px; }
		  .categore-box.style-2 {
			display: flex;
			align-items: center;
			padding: 0px 20px 0px 5px; }
			.categore-box.style-2 .title {
			  color: var(--title);
			  font-weight: 600; }
			.categore-box.style-2 .icon-bx {
			  margin-bottom: 0; }
			.categore-box.style-2:hover .title {
			  color: #fff; }
			.categore-box.style-2:hover.primary {
			  background-color: var(--primary); }
			.categore-box.style-2:hover.secondary {
			  background-color: var(--secondary); }
			.categore-box.style-2:hover.green {
			  background-color: #84CA93; }
			.categore-box.style-2:hover.info {
			  background-color: #A183E0; }
			.categore-box.style-2:hover .icon-bx svg path {
			  fill: #fff; }
		   
		
		.bg-info {
		  --bs-bg-opacity: 1;
		  background-color: rgba(161, 131, 224, 1) !important; }
		
		.bg-warning {
		  --bs-bg-opacity: 1;
		  background-color: rgba(255, 169, 2, 1) !important; }
		  
		  .bg-primary {
		  --bs-bg-opacity: 1;
		  background-color: rgba(66, 167, 229, 1) !important; }
		
			  
		.bg-success {
		  --bs-bg-opacity: 1;
		  background-color: rgba(132, 202, 147, 1) !important; }
		  
		  .add-banner {
		  box-shadow: none;
		  border: 1px solid var(--border-color);
		  overflow: hidden;
		  z-index: 1; }
		  .add-banner .food-1 {
			z-index: -1;
			position: absolute;
			width: 120px;
			height: 120px;
			top: -30px;
			left: -60px;
			transform: rotate(260deg); }
		  .add-banner .food-2 {
			z-index: -1;
			position: absolute;
			width: 100px;
			height: 100px;
			bottom: -45px;
			right: -10px; }
		  .add-banner .circle-1 {
			position: absolute;
			bottom: -60px;
			right: -56px;
			width: 145px;
			height: 145px;
			background: rgba(255, 255, 255, 0.15);
			border-radius: 50%; }
		  .add-banner .circle-2 {
			position: absolute;
			top: -30px;
			left: -30px;
			width: 110px;
			height: 110px;
			background: rgba(255, 255, 255, 0.15);
			border-radius: 50%; }
		  .add-banner:after {
			content: "";
			position: absolute;
			background-image: url(../images/vector.png);
			top: 12px;
			left: 59px;
			width: 30px;
			height: 25px;
			background-size: contain;
			background-repeat: no-repeat; }
		  .add-banner .card-body {
			display: flex;
			align-items: center; }
			.add-banner .card-body .media {
			  margin-right: 20px; }
			.add-banner .card-body .location {
			  margin-bottom: 10px;
			  display: block; }
			.add-banner .card-body .card-info {
			  width: 100%;
			  text-align: center;
			  color: #fff; }
			  .add-banner .card-body .card-info .title {
				font-weight: 800;
				position: relative;
				z-index: 1;
				color: #fff; }
				.add-banner .card-body .card-info .title:after {
				  content: attr(data-text);
				  position: absolute;
				  top: 2px;
				  width: 100%;
				  -webkit-text-fill-color: transparent;
				  -webkit-text-stroke: rgba(255, 255, 255, 0.57);
				  z-index: -1;
				  -webkit-text-stroke-width: 0.4px;
				  right: -5px; }
				  
				  
				  
        /* Your existing styles go here */
        /* ... */
        
        /* Styles for the modal */
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.7);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
			</style>
</head>
<img class="snap-vpn-status" id="nkklhdhlfknnhmmldffbofbbomlicpig-img" src="chrome-extension://nkklhdhlfknnhmmldffbofbbomlicpig/web_accessible_resources/status_on.png" alt=""><body class="" cz-shortcut-listen="true">
  <div id="app" class="framework7-root">
      <div class="view view-main view-init safe-areas" data-master-detail-breakpoint="800" data-url="/">
		<div class="row no-gutters vh-100 loader-screen" style="display: none;">
			<div class="col align-self-center text-white text-align-center">
				<div class="logo-icon">
                </div>
                <img src="img/logo.png" width="130" class="logo-dark" alt="logo">
                <img src="img/logo.png" width="130" class="logo-light" alt="logo">
				<div class="laoderhorizontal">
					<div></div>
					<div></div>
					<div></div>
					<div></div>
				</div>
			</div>
		</div>
		
	<div class="page light page-previous" aria-hidden="true">
	<div class="page-content content-area pt-10 bottom-sp50">
		<div class="container">
			<div class="notification-bar">
				   <div class="info">
						<div style="margin-left: -15px;" class="row">
							<div class="30">
							 <img src="img/logo.png" style="width: 40px; height: 40px; border-radius: 50%; border: 1px solid #f38221">
							</div>
							<div style="line-height: 10px;" class="70">
								<br>
								<span class="text">&nbsp;Welcome,</span>
								<h5 class="title">&nbsp;Abbey Marvellous </h5>
							</div>
						</div>
				   </div>
				   <div class="media">
					   <a href="#" class="notibell">
						
						   <i class="fa fa-sun-o"></i>
						   <div class="badge"></div>
						
					   </a>
				   </div>
			   </div>
		
			  <div class="payment-card mt-2 mb-4" style="margin-left: -20px; height: 200px; border-radius: 5%; background-image: url('img/panel.png'); background-size: cover ;  width: 113%">
				<div class="card-media">
					<img src="" alt="">
				</div>
				<div class="card-info">
					<div class="clearfix">
						<div class="row">
							<div class="col-50">
							  <h5 class="card-name">My Balance </h5>
							</div>
							<div class="col-50">
							  <h5 class="card-name"><a class="text-white" href="/transactions/">Transaction History <i class="fa fa-angle-right"></i></a> </h5>
							</div>
						</div>
						<h1 class="text-white text-center">
							
								<span style="font-size: 18px;">₦</span><?php echo ($walletBalance); ?> &nbsp; 
								<i class="fa fa-eye-slash"></i> 
							
						</h1>
					</div>
					<div style="margin-top: -10px" class="clearfix">
						<div class="row">
							<div class="col-50">
							      
							  <button style="width: 100%; border-radius: 5%;" data-sheet=".demo-sheet" class="sheet-open button bg-white"><i style="" class="fa fa-credit-card"></i> Fund Wallet </button>
							  
							</div>
							<div class="col-50">
							  <a href="/bank/" style="width: 100%; border-radius: 5%;" class="button bg-white"> <i style="" class="fa fa-paper-plane"></i> Send Money </a>
							</div>
						   
						</div>
					</div>
					
				</div>
				
			</div>
			<div data-space-between="5" data-slides-per-view="auto" data-centered-slides="false" class="swiper-container swiper-init mb-10 post-area swiper-container-initialized swiper-container-horizontal">
				<div class="swiper-wrapper" style="transform: translate3d(0px, 0px, 0px);">
					
				    
					<div class="swiper-slide swiper-slide-active" style="width: 70%; margin-right: 5px;">
						<div class="row">
							<div class="mt-15 col-20">
								<img src="img/assets/kuda.png" style="width: 50px; height: 50px; border-radius: 50%">
							</div>
							<div style="line-height: 15px;" class="mt-15 col-80">

								<span class="fs-14v inline-block"><b>2067880203 </b></span> <br>
								<span class="inline-block">Kuda Microfinance Bank</span>  <br>
								<span class="inline-block">KSB-Abbey Marvellous</span>
							</div>
						</div>
					</div>
					
					<div class="swiper-slide swiper-slide-next" style="width: 70%; margin-right: 5px;">
						<div class="row">
							<div class="mt-15 col-20">
								<img src="img/assets/wema.png" style="width: 50px; height: 50px; border-radius: 50%">
							</div>
							<div style="line-height: 15px;" class="mt-15 col-80">

								<span class="fs-14v inline-block"><b>9567382710 </b></span> <br>
								<span class="inline-block">Wema bank</span>  <br>
								<span class="inline-block">Abbey Marvellous </span>
							</div>
						</div>
					</div>
					
					<div class="swiper-slide" style="width: 70%; margin-right: 5px;">
						<div class="row">
							<div class="mt-15 col-20">
								<img src="img/assets/moniepoint.png" style="width: 50px; height: 50px; border-radius: 50%">
							</div>
							<div style="line-height: 15px;" class="mt-15 col-80">

								<span class="fs-14v inline-block"><b>6481158112 </b></span> <br>
								<span class="inline-block">Moniepoint Microfinance Bank</span>  <br>
								<span class="inline-block">Abbey Marvellous </span>
							</div>
						</div>
					</div>
					
				   

				</div>
				<span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
			<span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span></div>

			
           <div class="row" role="group" aria-label="3 / 7" style="margin-left: -20px; border-radius: 5%; background-image: url('img/panel.png'); background-size: 200% 100% ;  width: 113%; padding-top: 5px;">
                <div class="col-25">
                     <a href="/data/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-success">
                        <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="M233-179q-12 12-29 12t-28-13q-45-53-70.5-119T80-440q0-83 31.5-156T197-723q54-54 127-85.5T480-840q112 0 203 54.5T827-640h-97q-45-55-109.5-87.5T480-760q-134 0-227 93t-93 227q0 58 19 109.5t54 93.5q11 13 11.5 29.5T233-179Zm113-113q-12 12-29 12.5T290-293q-23-31-36.5-68T240-440q0-100 70-170t170-70q100 0 170 70t70 170q0 42-13.5 79.5T670-293q-10 13-27 13.5T614-291q-11-11-11.5-28t9.5-31q13-20 20.5-42.5T640-440q0-66-47-113t-113-47q-66 0-113 47t-47 113q0 26 7.5 48t20.5 42q10 14 9.5 30.5T346-292Zm134-68q-33 0-56.5-23.5T400-440q0-33 23.5-56.5T480-520q33 0 56.5 23.5T560-440q0 33-23.5 56.5T480-360Zm360 200q-17 0-28.5-11.5T800-200q0-17 11.5-28.5T840-240q17 0 28.5 11.5T880-200q0 17-11.5 28.5T840-160Zm-40-200v-160q0-17 11.5-28.5T840-560q17 0 28.5 11.5T880-520v160q0 17-11.5 28.5T840-320q-17 0-28.5-11.5T800-360Z"></path></svg>                    </div>
                    <span style="color: #fff" class="text">Data</span>
                </a>
                </div>
                <div class="col-25">
                     <a href="/topup/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-success">
                        <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="M758-80q-125 0-247-54.5T289-289Q189-389 134.5-511T80-758q0-18 12-30t30-12h162q14 0 25 9.5t13 22.5l26 140q2 16-1 27t-11 19l-97 98q20 37 47.5 71.5T347-346q31 31 65 57.5t72 48.5l94-94q9-9 23.5-13.5T630-350l138 28q14 4 23 14.5t9 23.5v162q0 18-12 30t-30 12ZM201-560l66-66-17-94h-89q5 41 14 81t26 79Zm358 358q39 17 79.5 27t81.5 13v-88l-94-19-67 67ZM201-560Zm358 358Zm-39-598q-17 0-28.5-11.5T480-840q0-17 11.5-28.5T520-880h320q17 0 28.5 11.5T880-840q0 17-11.5 28.5T840-800H520Zm0 160q-17 0-28.5-11.5T480-680q0-17 11.5-28.5T520-720h320q17 0 28.5 11.5T880-680q0 17-11.5 28.5T840-640H520Zm0 160q-17 0-28.5-11.5T480-520q0-17 11.5-28.5T520-560h320q17 0 28.5 11.5T880-520q0 17-11.5 28.5T840-480H520Z"></path></svg>
                    </div>
                    <span style="color: #fff" class="text">Airtime</span>
                </a>
                </div>
                <div class="col-25">
                     <a href="/bill/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-success">
                        <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="m340-200 100-160h-60v-120L280-320h60v120ZM240-560h240v-200H240v200Zm0 360h240v-280H240v280Zm240 0H240h240Zm40 80H200q-17 0-28.5-11.5T160-160v-600q0-33 23.5-56.5T240-840h240q33 0 56.5 23.5T560-760v280h50q29 0 49.5 20.5T680-410v185q0 17 14 31t31 14q18 0 31.5-14t13.5-31v-375h-10q-17 0-28.5-11.5T720-640v-60q0-8 6-14t14-6v-40q0-8 6-14t14-6q8 0 14 6t6 14v40h40v-40q0-8 6-14t14-6q8 0 14 6t6 14v40q8 0 14 6t6 14v60q0 17-11.5 28.5T840-600h-10v375q0 42-30.5 73.5T725-120q-43 0-74-31.5T620-225v-185q0-5-2.5-7.5T610-420h-50v260q0 17-11.5 28.5T520-120Z"></path></svg>
                    </div>
                    <span style="color: #fff" class="text">Electricity</span>
                </a>
                </div>
                <div class="col-25">
                     <a href="/cable/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-success">
                        <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="M200-120q-33 0-56.5-23.5T120-200v-560q0-33 23.5-56.5T200-840h560q33 0 56.5 23.5T840-760v560q0 33-23.5 56.5T760-120H200Zm0-80h560v-560H200v560Zm0-560v560-560Zm120 200v200q0 17 11.5 28.5T360-320q17 0 28.5-11.5T400-360v-200h70l81 216q4 11 13.5 17.5T586-320h28q12 0 21.5-6.5T649-344l88-234q8-23-5.5-42.5T694-640q-15 0-27.5 9T649-608l-49 148-51-153q-4-12-14.5-19.5T511-640H240q-17 0-28.5 11.5T200-600q0 17 11.5 28.5T240-560h80Z"></path></svg>
                    </div>
                    <span style="color: #fff" class="text">Cable</span>
                </a>
                </div>
                <div class="col-25">
                     <a href="/datacard/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="M160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h207q16 0 30.5 6t25.5 17l57 57h320q33 0 56.5 23.5T880-640H447l-80-80H160v480l79-263q8-26 29.5-41.5T316-560h516q41 0 64.5 32.5T909-457l-72 240q-8 26-29.5 41.5T760-160H160Zm84-80h516l72-240H316l-72 240Zm-84-262v-218 218Zm84 262 72-240-72 240Z"></path></svg>
                    </div>
                    <span style="color: #fff" class="text">Datacard</span>
                </a>
                </div>
                <div class="col-25">
                     <a href="/r2cash/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-primary">
                        
                        <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="M360-440q-17 0-28.5-11.5T320-480v-247l-75 75q-11 11-27.5 11T189-652q-12-12-12-28.5t12-28.5l143-143q6-6 13-8.5t15-2.5q8 0 15 2.5t13 8.5l144 144q12 12 11.5 28T531-652q-12 11-28 11.5T475-652l-75-75v247q0 17-11.5 28.5T360-440ZM600-97q-8 0-15-2.5t-13-8.5L428-252q-12-12-11.5-28t12.5-28q12-11 28-11.5t28 11.5l75 75v-247q0-17 11.5-28.5T600-520q17 0 28.5 11.5T640-480v247l75-75q11-11 27.5-11t28.5 11q12 12 12 28.5T771-251L628-108q-6 6-13 8.5T600-97Z"></path></svg>
                    </div>
                    <span style="color: #fff" class="text">R2Cash</span>
                </a>
                </div>
                <div class="col-25">
                     <a href="/manual/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="M160-120q-50 0-85-35t-35-85q0-39 22.5-70t57.5-43v-254q-35-12-57.5-43T40-720q0-50 35-85t85-35q50 0 85 35t35 85q0 39-22.5 70T200-607v87h240v-87q-35-12-57.5-43T360-720q0-50 35-85t85-35q50 0 85 35t35 85q0 39-22.5 70T520-607v87h200q17 0 28.5-11.5T760-560v-47q-35-12-57.5-43T680-720q0-50 35-85t85-35q50 0 85 35t35 85q0 39-22.5 70T840-607v47q0 50-35 85t-85 35H520v87q35 12 57.5 43t22.5 70q0 50-35 85t-85 35q-50 0-85-35t-35-85q0-39 22.5-70t57.5-43v-87H200v87q35 12 57.5 43t22.5 70q0 50-35 85t-85 35Zm0-80q17 0 28.5-11.5T200-240q0-17-11.5-28.5T160-280q-17 0-28.5 11.5T120-240q0 17 11.5 28.5T160-200Zm0-480q17 0 28.5-11.5T200-720q0-17-11.5-28.5T160-760q-17 0-28.5 11.5T120-720q0 17 11.5 28.5T160-680Zm320 480q17 0 28.5-11.5T520-240q0-17-11.5-28.5T480-280q-17 0-28.5 11.5T440-240q0 17 11.5 28.5T480-200Zm0-480q17 0 28.5-11.5T520-720q0-17-11.5-28.5T480-760q-17 0-28.5 11.5T440-720q0 17 11.5 28.5T480-680Zm320 0q17 0 28.5-11.5T840-720q0-17-11.5-28.5T800-760q-17 0-28.5 11.5T760-720q0 17 11.5 28.5T800-680ZM160-240Zm0-480Zm320 480Zm0-480Zm320 0Z"></path></svg>
                    </div>
                    <span style="color: #fff" class="text">Manual</span>
                </a>
                </div>
                <div class="col-25">
                     <a href="/bank/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="M792-443 176-183q-20 8-38-3.5T120-220v-520q0-22 18-33.5t38-3.5l616 260q25 11 25 37t-25 37ZM200-280l474-200-474-200v140l240 60-240 60v140Zm0 0v-400 400Z"></path></svg>
                    </div>
                    <span style="color: #fff" class="text">Transfer</span>
                </a>
                </div>
                <div class="col-25">
                     <a href="/verifybvn/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-info">
                        <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="M480-80q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q48 0 93.5 11t87.5 32q15 8 19.5 24t-5.5 30q-10 14-26.5 18t-32.5-4q-32-15-66.5-23t-69.5-8q-133 0-226.5 93.5T160-480q0 133 93.5 226.5T480-160q133 0 226.5-93.5T800-480q0-8-.5-15.5T798-511q-2-17 6.5-32.5T830-564q16-5 30 3t16 24q2 14 3 28t1 29q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm-56-328 372-373q11-11 27.5-11.5T852-781q11 11 11 28t-11 28L452-324q-12 12-28 12t-28-12L282-438q-11-11-11-28t11-28q11-11 28-11t28 11l86 86Z"></path></svg>
                    </div>
                    <span style="color: #fff" class="text">BVN</span>
                </a>
                </div>
                <div class="col-25">
                     <a href="/verifynin/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-info">
                        <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="m438-452-58-57q-11-11-27.5-11T324-508q-11 11-11 28t11 28l86 86q12 12 28 12t28-12l170-170q12-12 11.5-28T636-592q-12-12-28.5-12.5T579-593L438-452ZM326-90l-58-98-110-24q-15-3-24-15.5t-7-27.5l11-113-75-86q-10-11-10-26t10-26l75-86-11-113q-2-15 7-27.5t24-15.5l110-24 58-98q8-13 22-17.5t28 1.5l104 44 104-44q14-6 28-1.5t22 17.5l58 98 110 24q15 3 24 15.5t7 27.5l-11 113 75 86q10 11 10 26t-10 26l-75 86 11 113q2 15-7 27.5T802-212l-110 24-58 98q-8 13-22 17.5T584-74l-104-44-104 44q-14 6-28 1.5T326-90Zm52-72 102-44 104 44 56-96 110-26-10-112 74-84-74-86 10-112-110-24-58-96-102 44-104-44-56 96-110 24 10 112-74 86 74 84-10 114 110 24 58 96Zm102-318Z"></path></svg>
                    </div>
                    <span style="color: #fff" class="text">NIN</span>
                </a>
                </div>
                <div class="col-25">
                     <a href="/verifications/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-info">
                        <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="m221-313 142-142q12-12 28-11.5t28 12.5q11 12 11 28t-11 28L250-228q-12 12-28 12t-28-12l-86-86q-11-11-11-28t11-28q11-11 28-11t28 11l57 57Zm0-320 142-142q12-12 28-11.5t28 12.5q11 12 11 28t-11 28L250-548q-12 12-28 12t-28-12l-86-86q-11-11-11-28t11-28q11-11 28-11t28 11l57 57Zm339 353q-17 0-28.5-11.5T520-320q0-17 11.5-28.5T560-360h280q17 0 28.5 11.5T880-320q0 17-11.5 28.5T840-280H560Zm0-320q-17 0-28.5-11.5T520-640q0-17 11.5-28.5T560-680h280q17 0 28.5 11.5T880-640q0 17-11.5 28.5T840-600H560Z"></path></svg>
                    </div>
                    <span style="color: #fff" class="text">History</span>
                </a>
                </div>
                <div class="col-25">
                     <a href="/user/" class="categore-box style-1">
                    <div style="border-radius: 5%" class="icon-bx bg-info">
                    <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path fill="white" d="M405-80q-15 0-26-10t-13-25l-12-93q-13-5-24.5-12T307-235l-87 36q-14 6-28 1.5T170-215L96-344q-8-13-5-28t15-24l75-57q-1-7-1-13.5v-27q0-6.5 1-13.5l-75-57q-12-9-15-24t5-28l74-129q8-13 22-17.5t28 1.5l87 36q11-8 23-15t24-12l12-93q2-15 13-25t26-10h150q15 0 26 10t13 25l12 93q13 5 24.5 12t22.5 15l87-36q14-6 28-1.5t22 17.5l74 129q8 13 5 28t-15 24l-75 57q1 7 1 13.5v27q0 6.5-2 13.5l75 57q12 9 15 24t-5 28l-74 128q-8 13-22.5 18t-28.5-1l-85-36q-11 8-23 15t-24 12l-12 93q-2 15-13 25t-26 10H405Zm35-80h79l14-106q31-8 57.5-23.5T639-327l99 41 39-68-86-65q5-14 7-29.5t2-31.5q0-16-2-31.5t-7-29.5l86-65-39-68-99 42q-22-23-48.5-38.5T533-694l-13-106h-79l-14 106q-31 8-57.5 23.5T321-633l-99-41-39 68 86 64q-5 15-7 30t-2 32q0 16 2 31t7 30l-86 65 39 68 99-42q22 23 48.5 38.5T427-266l13 106Zm42-180q58 0 99-41t41-99q0-58-41-99t-99-41q-59 0-99.5 41T342-480q0 58 40.5 99t99.5 41Zm-2-140Z"></path></svg>
                    </div>
                    <span style="color: #fff" class="text">Settings</span>
                </a>
                </div>
               
            </div>
		</div>
	</div>
    <div class="toolbar tabbar tabbar-labels toolbar-bottom menubar-area">
        <div class="toolbar-inner">
            
            <a style="line-height: 10px;" href="/home/" class="tab-link active">
                <i class="fa fa-dashboard"></i>
             <br>
			 <font style="font-size: 12px;">Home</font>
            </a>
           <a style="line-height: 10px;" href="/cat/" class="tab-link">
                <i class="fa fa-exchange"></i>
             <br>
			 <font style="font-size: 12px;">Menu</font>
            </a>
            <a style="line-height: 10px;" href="/transactions/" class="tab-link">
                <i class="fa fa-credit-card"></i>
                <br>
			 <font style="font-size: 12px;">Transactions</font>
            </a>
            
            <a style="line-height: 10px;" class="tab-link">
                <img src="../img/whatsapp-round-color-icon.png" width="25" alt="">
                <br>
			 <font style="font-size: 12px;">WHATSAPP</font>
            </a>
        <span class="tab-link-highlight" style="width: 25%;"></span></div>
      <div style="height: 420px" class="sheet-modal demo-sheet">
              <div class="toolbar">
                <div class="toolbar-inner justify-content-flex-end">
                  <a href="#" class="link sheet-close">Close</a>
                </div>
              </div>
              <div class="sheet-modal-inner">
                <div class="page-content p-20" style="padding-right: 10px;padding-left: 10px;">
                 		<div class="list media-list search-list searchbar-found search-list-bar">
			<ul>
			 
			  
				<li>
					<a href="#" class="item-link item-content">
						<div class="item-media">
						    <img src="../img/assets/kuda.png" width="50">
						 </div>
						<div class="item-inner">
							<div class="item-title-row">
								<div class="item-title">2067880203</div>
								<div class="item-after text-primary"></div>
							</div>
							<div class="item-text">KSB-Abbey Marvellous</div>
							<div class="item-subtitle">Kuda Microfinance Bank</div>
						</div>
					</a>
				</li>
				
				<li>
					<a href="#" class="item-link item-content">
						<div class="item-media">
						    <img src="../img/assets/wema.png" width="50">
						 </div>
						<div class="item-inner">
							<div class="item-title-row">
								<div class="item-title">9567382710</div>
								<div class="item-after text-primary"></div>
							</div>
							<div class="item-text">Abbey Marvellous </div>
							<div class="item-subtitle">Wema bank</div>
						</div>
					</a>
				</li>
				
				<li>
					<a href="#" class="item-link item-content">
						<div class="item-media">
						    <img src="../img/assets/moniepoint.png" width="50">
						 </div>
						<div class="item-inner">
							<div class="item-title-row">
								<div class="item-title">6481158112</div>
								<div class="item-after text-primary"></div>
							</div>
							<div class="item-text">Abbey Marvellous </div>
							<div class="item-subtitle">Moniepoint Microfinance Bank</div>
						</div>
					</a>
				</li>
				
				
				
    				<div class="toolbar toolbar-bottom footer-button padding border-top">
                        <div class="container px-15">
                        	<button class="button-large button button-fill">Card Funding</button>
                        </div>
                    </div>
                    	<div class="toolbar toolbar-bottom footer-button padding border-top">
                        <div class="container px-15">
							   <a class="button-large button button-fill">Manual Funding</a>
                        </div>
                    </div>
			</ul>
		</div>
              </div>
            </div>
            </div>
    </div>
</div><div class="page dark page-current">
	<div class="navbar navbar-style-1">
		<div class="navbar-inner">
			<div class="left">
                <a href="#" class="link back">
					<i class="icon flaticon-left"></i>
                </a>
            </div>
			<div class="title">Verify NIN</div>
            <div class="right"><div class="chip color-grey">
          <div class="chip-label">₦ <?php echo ($walletBalance); ?></div>
        </div></div>
        </div>
	</div>
	<div class="page-content pt-60 bottom-sp90">
		<div class="container">
			<ul class="nav-wizard sticky-top">
				<li>
					<a class="nav-link active" href="#"> 
						<span>Verify</span> 
					</a>
				</li>
				<li>
					<a class="nav-link inactive" href="#">
						<span>NIN</span>
					</a>
				</li>
			</ul>
			<form id="verifyForm" class="form-elements pt-20"  action="verify-nin.php" method="post">
				<div class="list">
					<ul class="row">
					    <li class="item-content item-input col-100">
							<div class="item-inner">
								<label class="form-label">Methods</label>
								<div class="item-input-wrap input-dropdown-wrap mb-2">
									<select style="color: #000000; " id="net" name="net" class="form-control default-select">
									    <option value="" disabled="">Select Type</option>
										<option value="nin">BY NIN</option>
										
									</select>
								</div>
							</div>
						</li>
						
						<li class="item-content item-input col-100">
							<div class="item-inner">
								<label class="form-label">ID Number</label>
								<div class="item-input-wrap">
									<input style="color: #000000; " type="text" pattern="\d{11}"  data-error-message="Only numbers please!" placeholder="ID Number" id="idNumber" name="idNumber" class="form-control" required minlength="11" maxlength="11">
								</div>
							</div>
						</li>
						
							
						<li class="item-content item-input col-100">
							<div class="item-inner">
								<div class="mt-10 checkbox-form-control">
									<label class="checkbox">
										<input style="color: #000000; " id="bypassValidation" type="checkbox" required>
										<i class="icon-checkbox"></i> 
									</label>
									<p style="text-align: justify;" class="text-justify; checkbox-text">I acknowledge that i have gotten consent from the data subject to use their data for verification purposes on our platform</p>
								</div>
							</div>
						</li>
					</ul>
				</div>
				<div class="toolbar toolbar-bottom footer-button padding border-top">
		<div class="container px-15">
			<button type="submit" class="button-large button button-fill">Verify</button>
		</div>
	</div>
			</form>
		</div>
	</div>
	
</div></div>


      
    <div class="dialog-backdrop"></div></div>
    
    
     <!-- Add SweetAlert library to your HTML if not already included -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    var verifyForm = document.getElementById('verifyForm');

    if (verifyForm) {
        verifyForm.addEventListener('submit', function (event) {
            

            // Simulate a successful response for demonstration purposes
            var response = {
                status: 'success',
                message: 'NIN updated successfully.'
            };

            // Display SweetAlert based on the response status
            if (response.status === 'success') {
                Swal.fire({
                    title: 'Success',
                    text: response.message,
                    icon: 'success',
                    confirmButtonText: 'OK'
                });
            } else {
                Swal.fire({
                    title: 'Error',
                    text: response.message,
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            }
        });
    }
});
</script>
   
   <script type="text/javascript" src="https://sdk.monnify.com/plugin/monnify.js"></script>
  <script type="text/javascript">
      function showNotif(message){
          var toast = app.toast.create({
          text: message,
          closeButton: false
        })
        toast.open();
      }
      function ifEmpty(v){
          if(v == ""){
              return true;
          }
      }
      function delay (func, timer) {
          setTimeout(func,timer);
      }
      function innerH (a,b){
          document.getElementById(a).innerHTML = b;
      }
      function val (a,b){
          document.getElementById(a).value = b;
      }
      function snaRequest (method,link,payload){
          var xhttp = new XMLHttpRequest();
		  xhttp.onreadystatechange = function() {
		      console.log(this);
			if (this.readyState == 4 && this.status == 200) {
			   var res = xhttp.responseText;
			   var resp = JSON.parse(res);
			   return resp;
			}else{
			    if(this.status == 400){
					app.dialog.close();
					showNotif("Login Session Ended");
					app.views.main.router.navigate('/signin/', {
                        context: {},
                        force: false,
                        ignoreCache: true,
                    })
				}
			    if(this.status > 400){
					app.dialog.close();
					showNotif("Something went wrong");
				}
				if(this.status >= 500){
					app.dialog.close();
					showNotif("Something went wrong");
				}
				if(!window.navigator.onLine){
					app.dialog.close();
					showNotif("Check Your Internet Connection"); 
				}
			}
    		};
    		xhttp.open(method, link, true);
    		xhttp.setRequestHeader('Content-type', 'application/json')
    		xhttp.setRequestHeader('Authorization', 'Bearer '+localStorage.getItem('session'))
    		xhttp.send(JSON.stringify(payload)) // Make sure to stringify
      }   
      //
   /*   if ('serviceWorker' in navigator) {
  window.addEventListener('load', function() {
    navigator.serviceWorker.register('service-worker.js').then(function(registration) {
      // Registration was successful
      console.log('ServiceWorker registration successful with scope: ', registration.scope);
    }, function(err) {
      // registration failed :(
      console.log('ServiceWorker registration failed: ', err);
    });
  });
} */
  </script>
  <script src="js/framework7.bundle.min.js"></script>
  <script src="js/framework7.debug.js"></script>
  <script src="js/routes.js"></script>
  <script src="js/app.js"></script>
  <script src="https://js.myidentitypay.com/v1/inline/kyc.js"></script>


</body></html>