<?php require_once("../home/includes/route.php"); 
require_once("config.php"); // Include your database connection file
session_start();

// Check if the user is logged in
if (isset($_SESSION["loginId"])) {

    // Retrieve user information from the database based on loginId
    $loginId = $_SESSION["loginId"];
    $sql = "SELECT sFname, sWallet, sType FROM subscribers WHERE sId = ?";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        die("Error preparing SQL statement: " . $conn->error);
    }
    $stmt->bind_param("s", $loginId);
    $stmt->execute();
    $stmt->bind_result($firstName, $walletBalance, $userType);

    if ($stmt->fetch()) {
        // Output the user's information
        
        // Load the updateStatus function directly
        echo '<script>updateStatus(' . $userType . ', ' . $walletBalance . ');</script>';
    } else {
        // Handle the case where user information couldn't be retrieved
        echo "User information not available.";
    }

    // Close the database connection
    $stmt->close();
    $conn->close();
} else {
    // Handle the case where the user is not logged in
    echo "User is not logged in.";
}

?>




<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>KYC Verification Failed</title>
    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="images/logo.png" />
    <link rel="apple-touch-icon-precomposed" href="images/logo.png" />
    <!-- Font -->
    <link rel="stylesheet" href="fonts/fonts.css" />
    <!-- Icons -->
    <link rel="stylesheet" href="fonts/icons-alipay.css">
    <link rel="stylesheet" href="styles/bootstrap.css">

    <link rel="stylesheet" type="text/css" href="styles/styles.css" />
    <link rel="manifest" href="_manifest.json" data-pwa-version="set_in_manifest_and_pwa_js">
    <link rel="apple-touch-icon" sizes="192x192" href="app/icons/icon-192x192.png">
</head>

<body class="bg_surface_color">
    <!-- preloade -->
    <div class="preload preload-container">
        <div class="preload-logo">
          <div class="spinner"></div>
        </div>
      </div>
    <!-- /preload -->
    <div class="header is-fixed">
        <div class="tf-container">
            <div class="tf-statusbar d-flex justify-content-center align-items-center">
                <a href="#" class="back-btn"> <i class="icon-left"></i> </a>
                <h3>Verification Failed </h3>
            </div>
        </div>
    </div>
    <div id="app-wrap">
        <div class="bill-payment-content">
            <div class="tf-container">
            
                 <div class="wrapper-bill">
                     <div class="archive-top">
                         <span class="circle-box lg bg-critical check-icon">
                         
                         </span>
                         <h1><a href="#" class="critical_color">Failed</a></h1>
                         <h3 class="mt-2 fw_6">KYC Verification Failed!!! </h3>
                         <p class="fw_4 mt-2">Oops, your KYC verification was not successful!</p>
                     </div>
                     <div class="dashed-line"></div>
                     <div class="archive-bottom">
                         <h2 class="text-center">Possible Reasons</h2>
                         <ul>
                             <li class="list-info-bill">Invalid KYC information   <span> Main Reason  </</span> </li>
                            
                         </ul>
                     </div>
     
                 </div>
     
     
            </div>
          
         </div>
    </div>
  
    <div class="bottom-navigation-bar st1 bottom-btn-fixed">
        <div class="tf-container">
            <a href="../home/profile" class="tf-btn accent large">Back To Profile</a>
        </div>
    </div>
    












    <script type="text/javascript" src="javascript/jquery.min.js"></script>
    <script type="text/javascript" src="javascript/bootstrap.min.js"></script>
    <script type="text/javascript" src="javascript/count-down.js"></script>
    <script type="text/javascript" src="javascript/main.js"></script>

</body>


<!-- Mirrored from themesflat.co/html/alipay/alipay-app-pwa/51_bill-completly.html by HTTrack Website Copier/3.x [XR&CO'2017], Tue, 26 Sep 2023 13:27:42 GMT -->
</html>