<div class="col-12">
    <div class="card recent-sales overflow-auto">
        <div class="card-body">
            <h5 class="card-title">
                API Links
                <!-- Trigger the Modal -->
                <a class="btn btn-primary btn-sm btn-rounded text-white ml-2 float-end" data-toggle="modal" data-target="#addNewLink">
                    <i class="fa fa-plug" aria-hidden="true"></i> Add New API
                </a>
            </h5>
        </div>

        <table class="table table-borderless datatable">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">API Name</th>
                    <th scope="col">API Type</th>
                    <th scope="col">API Value</th>
                    <th scope="col">Edit API</th>
                    <th scope="col">Delete API</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                    $cnt = 1; 
                    $limit = 1000; 
                    $results = $controller->getApiLink($limit);
                    foreach ($results as $result) {
                ?>
                <tr>
                    <td><?php echo htmlentities($cnt);?></td>
                    <td><?php echo $result->name;?></td>
                    <td><?php echo $result->type;?></td>
                    <td><?php echo $result->value;?></td>
                    <td>
                        <a href="edit-api-link.php?aId=<?php echo urlencode($result->aId); ?>&name=<?php echo urlencode($result->name); ?>&type=<?php echo urlencode($result->type); ?>&value=<?php echo urlencode($result->value); ?>" class="btn btn-primary">
                            <b>Edit</b>
                        </a>
                    </td>
                    <td>
                        <form method="POST" action="delete-api-link.php">
                            <input type="hidden" name="id" value="<?php echo $result->aId;?>">
                            <button type="submit" name="delete-api-link" class="btn btn-danger">
                                <b>Delete</b>
                            </button>
                        </form>
                    </td>
                </tr>
                <?php 
                    $cnt = $cnt + 1;
                } 
                ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Add New API Modal -->
<div class="modal fade" id="addNewLink" tabindex="-1" role="dialog" aria-labelledby="addNewLinkLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-info">
                <h5 class="modal-title" id="addNewLinkLabel">Add New API Link</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST">
                    <div class="form-group">
                        <label for="providername">API Provider Name</label>
                        <input type="text" name="providername" placeholder="API Provider Name" class="form-control" required />
                    </div>
                    <div class="form-group">
                        <label for="providerurl">API URL</label>
                        <input type="text" name="providerurl" placeholder="API URL" class="form-control" required />
                    </div>
                    <div class="form-group">
                        <label for="service">Service</label>
                        <select name="service" class="form-control" required>
                            <option value="">Select Service</option>
                            <option value="Wallet">Wallet</option>
                            <option value="Airtime">Airtime</option>
                            <option value="Data">Data</option>
                            <option value="Recharge Card">Recharge Card</option>
                            <option value="Data Pin">Data Pin</option>
                            <option value="CableVer">Cable Verification</option>
                            <option value="Cable">Cable</option>
                            <option value="ElectricityVer">Electricity Verification</option>
                            <option value="Electricity">Electricity</option>
                            <option value="Exam">Exam</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <div class="d-flex justify-content-between">
                            <button type="submit" name="add-new-api-link" class="btn btn-info">
                                <i class="fa fa-plus" aria-hidden="true"></i> Add API
                            </button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>